/*
 * Send an UDP packet containing the program version and UID
 * to a compiled-in address 
 */

#ifndef DO_NOT_TELL_ABOUT_ME
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <sys/utsname.h>
/*
 * Waiting is probably non-portable; wait until hits(fan, shit...)
 * ...fan was hit on Solaris 2; changed from wait3 to waitpid... 
 */
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>

#ifndef UDP_PORT_NO
#define UDP_PORT_NO 29659
#endif
#ifndef UDP_HOST_NAME
#define UDP_HOST_NAME "logger.htalvestrand.priv.no"
#endif
#ifndef UDP_HOST_NO
#define UDP_HOST_NO "129.241.131.10"
#endif

extern uid_t    getuid();
extern int      socket();
extern int      sendto();
extern int      close();

void
waitforchild(sig)
     int sig;
{
   /*
    * Expect only one. Ought to restore handler 
    */
   (void) waitpid(-1, NULL, WNOHANG);
}

static int
iamhere(progname)
     char *progname;
{
   char            buffer[80];
   int             s, err;
   struct sockaddr_in to;
   struct protoent *udp;
   struct utsname  name;
   struct hostent *host;

   /*
    * This routine is made to leave on ANY error AT ALL 
    */
   host = gethostbyname(UDP_HOST_NAME);
   /*
    * Solaris returns > 0, others return = 0 
    */
   if (uname(&name) < 0) {
      sprintf(buffer, "[%d ???] %.60s", (int) getuid(), progname);
   } else {
      /*
       * Get machine, opsys and release from uname stuff 
       */
      sprintf(buffer, "[uid=%d hw=%.10s os=%.10s osver=%.10s dns=%s] %.40s",
	      (int) getuid(),
	      name.machine, name.sysname, name.release,
	      host ? "yes" : "no",
	      progname);
   }
   udp = getprotobyname("udp");
   if (!udp)
      return -1;
   s = socket(PF_INET, SOCK_DGRAM, udp->p_proto);
   if (s == -1)
      return -1;
   to.sin_family = AF_INET;
   to.sin_port = htons(UDP_PORT_NO);
   if (host) {
      to.sin_addr.s_addr = *(u_long *) * (host->h_addr_list);
   } else {
      to.sin_addr.s_addr = inet_addr(UDP_HOST_NO);
   }
   if (to.sin_addr.s_addr == -1)
      return -1;
   err = sendto(s, buffer, strlen(buffer), 0, (struct sockaddr *) &to,
		sizeof(to));
   (void) close(s);
   if (err == -1)
      return -1;
   return 0;
}

int
sayiamhere(progname)
     char *progname;
{
   int             stat;

   /*
    * Isolate the call in a new process 
    */
   (void) signal(SIGCHLD, waitforchild);
   if (fork() != 0) {
      return 0;
   }
   stat = iamhere(progname);
   exit(stat != 0 ? 1 : 0);
}


#else
static char     nothing[] = "This sentence no verb: this module no content";

#endif
/*
 * DO_NOT_TELL_ABOUT_ME 
 */
